import datetime as dt

def getApiCheck(apikey):
    request = {"method": "/apicheck/getinfo","reportsVirtualPrint":"true","beep":"yesplease","show":"minimum"}  # python dict
    return request

def getSaleSimpleRequest(apikey):
    request = {"method": "/api", "key": apikey, "sale": "800", "cash": "1000"}  # python dict
    print("Using APIKEY:",apikey)
    return request

def getSaleWithFooterRequest(apikey):
    request = {"method": "/api", "key": apikey, "sale": "800", "cash": "1000","footer":"footer start  --barcode128-TEST&(ab~)<@>-- *footer end*"}  # python dict
    print("Using APIKEY:",apikey)
    return request

def getZreportRequest(apikey):
    request = {"method": "/apizreport", "key": apikey}
    return request

def getBankPurchaseRequest(apikey):
    a = dt.datetime(2020, 1, 1, 23, 59, 59)
    b = dt.datetime.now()
    ts = int((b - a).total_seconds())

    request = {"method": "/apibank", "key": apikey,
                "amount" : "100",
                "showSlotMenu" : "false",
                "customerSlip" : "false",
                "message": "purchase",
                "trackdocument": ts,
                "bankSlot": "1" }
    print("Bank TrackDocument is:",ts)
    return request

def getBankReconciliation(apikey):
    request = {"method": "/apibank", "key": apikey,
                "showSlotMenu" : "false",
                "customerSlip" : "false",
                "message": "reconciliation",
                "bankSlot": "1" }
    return request

def getSaleNormalRequest(apikey):
    large_itemdata = [{"name": "NESQUIK DUO РИО 375 ","price": "924","qty": "1","sum": "924","taxid":"2"},
                        {"name": "П/Ф ФАРШ ОСОБЫЙ   ","price": "924","qty": "1"  ,"sum": "924", "taxid":"2"},
                        {"name": "БУЛЬОН 72 С КУРИЦЕЙ ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЛАПША С КУРИЦЕЙ 90  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "БАУРСАКИ            ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "П/Ф УПАК.КУРИЦА     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЛАПША ЛАГМАН        ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЛАПША ГОВЯДИНА 90   ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЗАПРАВКА Д/ФУНЧЕЗЫ60","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КЕТЧУП ИТАЛЬЯНС.350 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЗАПРАВКА 80 КУНЖУТ. ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ВЫП.БАГЕТ ФРАНЦ. 300","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КУКУРУЗА МОЛОДАЯ 340","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ПРИПРАВА УНИВЕР. 75 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ТВОРОЖОК ФИС.МОР.130","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЙП СМУССИ КЛ/АН 250Г","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ТВОРОЖ.130г МАНГ МАР","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ШПРОТЫ 270 В МАСЛЕ  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КАША КЛУБН/МОЛОКО 40","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КАША ОВС.ЛЕСН.ЯГ 40 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ХЛОПЬЯ 4 ЗЛАКА 350  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ФИТНЕС ЙОГУРТ ХЛ.245","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "МОРСКАЯ СОЛЬ 250    ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "МОЛОКО 7,1% Т/П 300 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СЛИВКИ 350 20%      ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ТВОРОГ 5% 220 ГР.   ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "НАРЕЗКА БЕКОН 120Г  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ТОМ.ПАСТА 198       ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СЛИВОЧН.БЕРЕГА 180ГР","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "МОЛОКО LACTEL1л 2,5%","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ДК АКТИВ  МЮСЛИ 3,2%","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЙП 3,2%900млКАРАМЕЛЬ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЯЙЦО ОТБОРНОЕ 15шт  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ГОТ.ЗАВТ 250 КАР/ШОК","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "TORTIGLIONI 500     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "BUCATINI 400гр      ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СЫР ЧЕЧИЛ СОЧИНСКИЙ ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "САХАР ПЕСОК 1кг     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КОРНИШОНЫ 3-6см 370 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "STICK SHOWER CLEAN","price": "924","qty": "1","sum": "924", "taxid":"2"}]
    request = {"method": "/api", "key": apikey, "sale": "36960", "cash": "36960","itemdata":large_itemdata}
    print("Using APIKEY:",apikey)
    return request


def getSaleMAXRequest(apikey):
    large_itemdata = [{"name": "NESQUIK DUO РИО 375 ","price": "924","qty": "1","sum": "924","taxid":"2"},
                        {"name": "П/Ф ФАРШ ОСОБЫЙ   ","price": "924","qty": "1"  ,"sum": "924", "taxid":"2"},
                        {"name": "БУЛЬОН 72 С КУРИЦЕЙ ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЛАПША С КУРИЦЕЙ 90  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "БАУРСАКИ            ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "П/Ф УПАК.КУРИЦА     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЛАПША ЛАГМАН        ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЛАПША ГОВЯДИНА 90   ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЗАПРАВКА Д/ФУНЧЕЗЫ60","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КЕТЧУП ИТАЛЬЯНС.350 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЗАПРАВКА 80 КУНЖУТ. ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ВЫП.БАГЕТ ФРАНЦ. 300","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КУКУРУЗА МОЛОДАЯ 340","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ПРИПРАВА УНИВЕР. 75 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ТВОРОЖОК ФИС.МОР.130","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЙП СМУССИ КЛ/АН 250Г","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ТВОРОЖ.130г МАНГ МАР","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ШПРОТЫ 270 В МАСЛЕ  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КАША КЛУБН/МОЛОКО 40","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КАША ОВС.ЛЕСН.ЯГ 40 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ХЛОПЬЯ 4 ЗЛАКА 350  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ФИТНЕС ЙОГУРТ ХЛ.245","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "МОРСКАЯ СОЛЬ 250    ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "МОЛОКО 7,1% Т/П 300 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СЛИВКИ 350 20%      ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ТВОРОГ 5% 220 ГР.   ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "НАРЕЗКА БЕКОН 120Г  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ТОМ.ПАСТА 198       ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СЛИВОЧН.БЕРЕГА 180ГР","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "МОЛОКО LACTEL1л 2,5%","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ДК АКТИВ  МЮСЛИ 3,2%","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЙП 3,2%900млКАРАМЕЛЬ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ЯЙЦО ОТБОРНОЕ 15шт  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ГОТ.ЗАВТ 250 КАР/ШОК","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "TORTIGLIONI 500     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "BUCATINI 400гр      ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СЫР ЧЕЧИЛ СОЧИНСКИЙ ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "САХАР ПЕСОК 1кг     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КОРНИШОНЫ 3-6см 370 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "TOFFIFEE 125        ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "ГЕЛЬ Д/ДУША ПИРАТ   ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "БАЛЬЗ 200 БЕЗУП ДЛИН","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СОЧНЫЙ АРБУЗ        ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СОСИСКИ СЛИВОЧНЫЕ450","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "HEINEKEN 0,45Л ЖБ   ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "МАЙОН.НА ПЕР.ЯЙЦ.220","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "РИС ОБРАБ/ПАРОМ 800 ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "FOREST DREAM 20п.   ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "GINGER MOJITO 20п.  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "КАША ЧЕРНИКА 43     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СЫР ПЛ.АССОРТИ 150гр","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СЫР ТВОРОЖНЫЙ 140ГР ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "З/П 74гр ЯГОДН МИКС ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "КАЛЬМАР КОПЧЕНЫЙ 18г","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "РЫБКА ЯНТАРНАЯ 40гр ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "ЯНТАРКА СОЛОМКА 25гр","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "REXONA 40мл АНТИБАК ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "ПАПАЙЯ СУШЕНАЯ 100гр","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "РАХАТ-ЛУКУМ С АРАХ  ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "АРАХИС КАРАВАН 90гр ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "СЫР РОСС 50%        ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "САЛФ ФЛАМЕНКО 6шт   ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "ПАК д/мус 35л 15шт С","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "БОРЖОМИ 1,25л ПЭТ   ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "МАСЛО ПОДСОЛНЕЧН.1л ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "СГУЩЕН/ЦЕЛЬНОЕ 380  ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "СУШКА МАЛЮТКА   200г","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "ALBENI ХХL 70гр     ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "КАРИНА СТАН БЕЛ 100ш","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "МАС.КР.СЛ.72,5% 180Г","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "ЙП КЛУБ.ЗЕМЛЯН.670ГР","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "ЦУКАТЫ 250гр        ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "ФИНИКИ АЛТЫН 650гр  ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "SNICKERS ЛЕСНОЙ ОРЕХ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "GLADE 300 ГРЕЙПФРУТ ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "COLGATE 100 МаксБлес","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "Т/Б ZEWA ПЛЮС СИР 4Р","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "OREO КАКАО/ВАНИЛЬ228","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "ФУНДУК И МЕД 225    ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "EXTRA VIRGIN 250    ","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "ОЛИВКИ BRAVO ЧЕР.Б/К","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "REXONA MEN 150 НЕВИД","price": "924","qty": "1","sum": "924", "taxid":"1"},
                        {"name": "AXE 17МЛ APOLLO     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "СУБЛИМИРОВ.Д/П 150  ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "DIZZT ENERGY Ж/Б 0,5","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "AURA ВЛ.САЛФ ЛИМ/РОМ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "AURA МЕНТОЛ15шт     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "TWIX XTRA 82        ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "COCA-COLA 0,5л      ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "COMET 475 ЛИМОН     ","price": "924","qty": "1","sum": "924", "taxid":"2"},
                        {"name": "STICK SHOWER CLEAN","price": "924","qty": "1","sum": "924", "taxid":"2"}]
    request = {"method": "/api", "key": apikey, "sale": "84084", "cash": "94084","itemdata":large_itemdata}
    print("Using APIKEY:",apikey)
    return request